/******************************************************************************
*   Definitions and declarations for STB_MCU project on QG8;                  *
******************************************************************************/
#ifndef _APPLICATION_H
#define _APPLICATION_H


/* Definitions */
#define BUS_SPEED 8000000       /* Hz */
#define CONST (BUS_SPEED / 1000 /*ms*/ / 8 /* loop cycles*/ ) 
#define LENGTH          8       // No of characters of SCI message;
#define GPIORF          PTAD_PTAD0
#define PGOOD           PTAD_PTAD1
#define SDA             PTAD_PTAD2
#define SCL             PTAD_PTAD3

#define IIC_SLAVE       0xA0     // For KA2 or QE8 MCU;

/* Commands Definitions */
#define STB_OFF         0x0C

//----- Macro for Vectors recognition ------
#define IV(x) ((0xFFFE-(x))/2)

/* Global variables */
byte temp, RD_data, WR_data, my_IIC_RX_data, my_IIC_TX_data, flag, IIC_Res_flg;
byte SCI_Data[LENGTH];

const byte PWR_ON[] = " STB ON ";
const byte PWR_OFF[] = " STB OFF";
const byte PWR_FAIL[] = "PWR FAIL";

/* Initialization of the CPU registers in FLASH */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E; 

/* Function declarations */
void MCU_init(void);
void Init_Variables(void);
void Delay(byte del);
void Wait1ms(void);
void WaitNms(word del);
void SCI_send_byte(byte data);
void SCI_send_string(const byte *str);
void Reset_IIC(void);
void Test_IIC_Bus(void);
void IIC_write_byte(byte data);
byte IIC_read_byte(void);


//-----------------------------------------------------------------------------
#endif /* _APPLICATION_H */
